//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_savebuilding.cs
// brief:
//    This handles the saving and loading of buildings through
//    script, ensuring that the dynamic fields of objects and
//    timers are appropriately saved and initialized on load.
//------------------------------------------------------------


// CLIENT-SIDE LOADING

function clientCmdLoadRecruits(%ghostID, %data)
{
   %component = ServerConnection.resolveGhostId(%ghostID);
   %object = %component.getObjectId();
}

function clientCmdLoadBuildingConstruction(%ghostID, %data)
{
   %component = ServerConnection.resolveGhostId(%ghostID);
   %object = %component.getObjectId();
   %datablock = %component.getDataBlock();
 
   %dataIndex = -1;
   if (%object.isLinkObj() == true)
   {
      %object.linkStart = getWord(%data, %dataIndex++);
      %object.linkDirection = getWord(%data, %dataIndex++);
      %object.linkCount = getWord(%data, %dataIndex++);
      %object.linkHealth = getWord(%data, %dataIndex++);
   }
   
   // load the client-side construction timer
   if (%datablock.constructionTime)
   {
      %component.timer = new SLTimer()
      {
         time = %datablock.constructionTime;
      };
      %elapsedTime = getWord(%data, %dataIndex++);
      %component.timer.setElapsedTime(%elapsedTime);
      
      if (%object.isLinkObj() == false || %object.linkStart == false)
      {
         %component.timer.notifyOnFire(stopConstruction, %component);
      }
   }

   %component.constructionPosition = getWord(%data, %dataIndex++) @ " " @
      getWord(%data, %dataIndex++) @ " " @ getWord(%data, %dataIndex++);

   if (%object.linkStart == true || %object.isLinkObj() == false)
   {
      CreateHealthClock(%object);
   }
}
